/*!
    \file
    \copyright  (c) 2015 Jascha Wetzel. All rights reserved.
 */

#ifndef API_BASE_H
#define API_BASE_H

#include <stdint.h>

namespace tfd {
namespace api {

/*!
    Base interface used to manage API objects.
 */
struct Base
{
    virtual ~Base()
    {}

    /*!
        Don't call this directly.
        Use wrap_raw_iface_pointer() instead.
     */
    virtual void release() = 0;
};

/*!
    Obtain server's API version.
 */
struct ServerVersion : Base {
    virtual uint32_t version() const = 0;
};

const uint32_t
    CLIENT_VERSION = 3u;

} // namespace api
} // namespace tfd

#endif // API_BASE_H
